package main

import (
	"context"
	"fmt"
	"math/rand"
	"time"
)

// Utwórz program, którego działanie będzie polegało na dodawaniu losowo
// wygenerowanych liczb z przedziału od 0 (włącznie) do 100 000 000 (bez tej
// wartości), dopóki nie wystąpi jeden z dwóch warunków: nastąpi wygenerowanie
// liczby 1234 bądź upłyną 2 sekundy. Wyświetl sumę, liczbę iteracji i powód
// zakończenia działania programu (upłynięcie określonego czasu bądź
// wygenerowanie wskazanej liczby).

func main() {
	ctx, cancelFunc := context.WithTimeout(context.Background(), 2*time.Second)
	defer cancelFunc()
	total := 0
	count := 0
	for {
		select {
		case <-ctx.Done():
			fmt.Println("total:", total, "number of iterations:", count, ctx.Err())
			return
		default:
		}
		newNum := rand.Intn(100_000_000)
		if newNum == 1_234 {
			fmt.Println("total:", total, "number of iterations:", count, "got 1,234")
			return
		}
		total += newNum
		count++
	}
}
